<?php
/*
**==============================   
** Vankine Blog
**==============================
*/
add_action('vankine_theme_blog_comments', 'vankine_comments');
add_action('vankine_theme_blog_time', 'vankine_blog_time');
add_action('vankine_theme_blog_category', 'vankine_blog_category');
add_action('vankine_theme_blog_share', 'vankine_share_options');
add_action('vankine_theme_blog_tags_and_cat', 'vankine_tags_and_cat');
add_action('vankine_theme_blog_tags_and_catbefore', 'vankine_tags_and_cat_before_intsll_pg');
add_action('vankine_after_blogsetup_comment_timing', 'vankine_comment_timing');
/*
**=========================================
**vankine Ecommerce get-comments
**=========================================
*/
function vankine_comments(){
    global $post;
?>
<small class="comments">
    <i class="far fa-comment-dots"></i>
    <?php echo comments_popup_link( 
        esc_html__( 'Post a Comment', 'vankine' ), 
        esc_html__( '1 Comment', 'vankine' ), 
        esc_html__( '% Comments', 'vankine' ),
        esc_html__( 'Comments are Closed', 'vankine' )
    ); 
?>
</small>
<?php   
}   
/*
**==============================   
** vankine Ecommerce vankine_blog_time
**==============================
*/
function vankine_blog_time(){
    $time_string = '<time class="date published updated" datetime="%1$s">%2$s</time>';
    if(get_the_time('U') !== get_the_modified_time('U')):
        $time_string = '<time class="date published" datetime="%1$s">%2$s</time>';
    endif;    
    $time_string = sprintf($time_string, esc_attr(get_the_date('c')) , esc_html(get_the_date(get_option('date_format'))));
    $posted_on = '<span class="date_tm"><i class="fi-rr-calendar"></i> ' . $time_string . '</span>';
    echo '' . $posted_on . '';
}   
/*
**===================================
**vankine Ecommerce vankine_blog_category
**===================================
*/
function vankine_blog_category(){
$categories = get_the_category();
    if(!empty($categories)) {
        echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '" class="cat_gry">' . esc_html( $categories[0]->name ) . '</a>';
    }
}   

/*
**==============================   
**vankine post share
**==============================
*/
function vankine_share_options(){  ?>
<div class="social-icons single-share">
<h6> <?php echo esc_html('Share This : ' , 'creote');?>  </h6>
<ul class="text-grey-5 d-inline-block">
        <li class="social-mds">
            <button class="m_icon" data-toggle="tooltip" data-placement="right" title="facebook" data-sharer="facebook"
                data-title="<?php the_title(); ?>" data-url="<?php the_permalink(); ?>">
                <i class="fab fa-facebook"></i>
            </button>
        </li>
        <li class="social-mds">
            <button class="m_icon" data-toggle="tooltip" data-placement="right" title="twitter" data-sharer="twitter"
                data-title="<?php the_title(); ?>" data-url="<?php the_permalink(); ?>">
                <i class="fab fa-twitter"></i>
            </button>
        </li>
        <li class="social-mds">  
        <button class="m_icon" data-sharer="whatsapp" data-web="true" data-link="true" data-blank="true" data-title="<?php the_title(); ?>" data-url="<?php the_permalink(); ?>"><i class="fab fa-whatsapp"></i></button> 
        </li>
        <li class="social-mds"> 
        <button class="m_icon" data-sharer="telegram" data-title="<?php the_title(); ?>" data-url="<?php the_permalink(); ?>"><i class="fab fa-telegram"></i></button> 
        </li>
        <li class="social-mds">
            <button class="m_icon" data-toggle="tooltip" data-placement="right" title="skype" data-sharer="skype"
                data-url="<?php the_permalink(); ?>" data-title="<?php the_title(); ?>">
                <i class="fab fa-skype"></i>
            </button>
        </li>
    </ul>
</div>
<?php
}   

 
/*
**==================================
**vankine Ecommerce get-tags-and-share
** =================================
*/
add_action('vankine_theme_authour_details', 'vankine_authour_details', 25);
    function vankine_authour_details(){
        ?>
<div class="same_authour">
    <div class="image">
        <?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'Vankine-authour', 100 )); ?>
    </div>
    <div class="content">
        <h4 class="title_no_a_22">
            <?php the_author(); ?>
        </h4>
      
   
        <p>
            <?php the_author_meta('description') ?>
        </p>
       
      
        <div class="social-icons d-flex align-items-center authour-share">
        <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>" class="theme_btn">
            <?php echo esc_html_e('Read All Post' , 'vankine'); ?>
        </a>
            <ul class="d-inline-block">
                <li class="social-mds">
                    <button  data-toggle="tooltip" data-placement="right" title="facebook"
                        data-sharer="facebook" data-title=" <?php the_author(); ?>"
                        data-url="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                        <i class="fab fa-facebook"></i>
                    </button>
                </li>
                <li class="social-mds">
                    <button data-toggle="tooltip" data-placement="right" title="twitter"
                        data-sharer="twitter" data-title=" <?php the_author(); ?>"
                        data-url="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                        <i class="fab fa-twitter"></i>
                    </button>
                </li>
                <li class="social-mds">
                    <button data-toggle="tooltip" data-placement="right" title="whatsapp"
                        data-sharer="whatsapp" data-title=" <?php the_author(); ?>"
                        data-url="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>">
                        <i class="fab fa-whatsapp"></i>
                    </button>
                </li>
                <li class="social-mds">
                    <button  data-toggle="tooltip" data-placement="right" title="telegram"
                        data-sharer="telegram" data-title=" <?php the_author(); ?>"
                        data-url="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"
                        data-to="+44555-03564">
                        <i class="fab fa-telegram"></i>
                    </button>
                </li>
                <li class="social-mds">
                    <button   data-toggle="tooltip" data-placement="right" title="skype"
                        data-sharer="skype" data-url="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"
                        data-title=" <?php the_author(); ?>">
                        <i class="fab fa-skype"></i>
                    </button>
                </li>
            </ul>
        </div>
 
    </div>
</div>

<?php
}
/*
**==================================
**vankine Ecommerce get-tags-and-share
** =================================
*/
function vankine_tags_and_cat(){
    global $vankine_theme_mod;
$get_the_categorys = get_the_category();
$tag_outputs = get_the_tags();

if((!empty($vankine_theme_mod['tag_disable']) == true) || (!empty($vankine_theme_mod['category_enable']) == true)): ?>
<div
    class="tags_and_cat<?php if((!empty($tag_outputs)) && (!empty($vankine_theme_mod['tag_disable']) == true)):?> yes_tags<?php endif; ?> <?php  if((!empty($get_the_categorys)) && (!empty($vankine_theme_mod['category_enable']) == true)):?>yes_share<?php endif; ?>">
    <div class="d-flex">
        <?php  if(!empty($vankine_theme_mod['tag_disable']) == true): ?>
            <?php if(!empty($tag_outputs)): ?>
        <div class="left_one d-flex">
            <div class="title"><?php echo esc_html__('Tags' , 'vankine'); ?></div>
            <?php foreach ($tag_outputs as $tag_output):?>
            <a class="tags" href="<?php echo get_term_link($tag_output); ?>"><?php echo esc_html('#' , 'vankine');?>
                <?php echo esc_attr($tag_output->name); ?></a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php if(!empty($vankine_theme_mod['category_enable']) == true): ?>
        <?php if(!empty($get_the_categorys)): ?>
        <div class="right_one d-flex">
            <div class="title"><?php echo esc_html__('Posted in' , 'vankine'); ?></div>
            <?php foreach ($get_the_categorys as $get_the_category):?>
            <a class="cats"
                href="<?php echo get_term_link($get_the_category); ?>">
                <?php echo esc_attr($get_the_category->name); ?></a>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>
<?php 
}   

/*
**==================================
**vankine Ecommerce get-tags-and-share
** =================================
*/
function vankine_tags_and_cat_before_intsll_pg(){
 
$get_the_categorys = get_the_category();
$tag_outputs = get_the_tags(); ?>
<div
    class="tags_and_cat<?php if(!empty($tag_outputs)):?> yes_tags<?php endif; ?> <?php  if(!empty($get_the_categorys)):?>yes_share<?php endif; ?>">
    <div class="d-flex">
 
            <?php if(!empty($tag_outputs)): ?>
        <div class="left_one d-flex">
            <div class="title"><?php echo esc_html__('Tags' , 'vankine'); ?></div>
            <?php foreach ($tag_outputs as $tag_output):?>
            <a class="tags" href="<?php echo get_term_link($tag_output); ?>"><?php echo esc_html('#' , 'vankine');?>
                <?php echo esc_attr($tag_output->name); ?></a>
            <?php endforeach; ?>
        </div>
    
        <?php endif; ?>
 
        <?php if(!empty($get_the_categorys)): ?>
        <div class="right_one d-flex">
            <div class="title"><?php echo esc_html__('Posted in' , 'vankine'); ?></div>
            <?php foreach ($get_the_categorys as $get_the_category):?>
            <a class="cats"
                href="<?php echo get_term_link($get_the_category); ?>"><?php echo esc_html('#' , 'vankine');?>
                <?php echo esc_attr($get_the_category->name); ?></a>
            <?php endforeach; ?>
        </div>
      
        <?php endif; ?>
    </div>
</div>
 
<?php 
}  
/*
**================================   
**vankine Ecommerce Comment Timing
**================================
*/
function vankine_comment_timing() { 
    ?>
        <i class="fi-rr-calendar"></i>
    <?php
    $comment_date = get_comment_time('U');
    $dayscommnet = round((date('U') - get_comment_time('U')) / (60*60*24));
    $deltacomment = time() - $comment_date;
    if($deltacomment < 60):
        echo esc_html('Less than a minute ago' , 'creote');
    elseif($deltacomment > 60 && $deltacomment < 120):
        echo esc_html('About a minute ago' , 'creote');
    elseif($deltacomment > 120 && $deltacomment < (60*60)):
        echo strval(round(($deltacomment/60),0)), ' minutes ago';
    elseif($deltacomment > (60*60) && $deltacomment < (120*60)):
        echo esc_html('About an hour ago' , 'creote');
    elseif($deltacomment > (120*60) && $deltacomment < (24*60*60)):
        echo strval(round(($deltacomment/3600),0)), ' hours ago';
    else:
        echo  get_comment_date();
    endif;
}  