<?php 
/*
====================
Create fields
Show columns
Save/Update fields
Update the Walker nav
====================
*/ 
/*Enqueue scripts for Edit Menu upload image*/
add_action('admin_enqueue_scripts', function(){
	wp_enqueue_media();
	wp_enqueue_script( 'vankine-nav-menu', get_template_directory_uri().'/assets/js/admin-media.js', array('jquery'), '', true );
});

/**
 * Passing Classes to Menu
 */
add_action( 'wp_nav_menu_item_custom_fields','vankine_custom_field', 10, 2 );

function vankine_custom_field ($item_id, $item){
$badge_item       = get_post_meta( $item_id, 'vankine_badge_item', true );
$dropcolumn       = get_post_meta( $item_id, 'vankine_dropcolumn', true );
$megamenu_select = get_post_meta( $item_id, 'vankine_megamenu_select', true );
$show_as_megamenu = get_post_meta( $item_id, 'vankine_show-as-megamenu', true );
$image_style       = get_post_meta( $item_id, 'vankine_image_style', true );
?>

<p class="description-wide vankine_same_call bdge_con">
	<label class="description"><?php esc_html_e( 'Badge', 'vankine' ); ?></label>
	<input type="text" id="badge_item" name="badge_item[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($badge_item); ?>" placeholder="<?php esc_attr_e( 'New', 'vankine' ); ?>" />
</p>

<?php if($item->menu_item_parent == '0'): ?>
	<p><?php echo esc_html_e('To add megamenu enable check box and select megamenu' , 'vankine') ?></p>
	<p class="description-wide megmenuvancutom">
		<label for="megamenu-item-<?php echo esc_attr($item_id); ?>"><?php _e( 'Mega menu', 'vankine' ); ?> </label>
		<input type="checkbox" id="megamenu-item-<?php echo esc_attr($item_id); ?>" name="megamenu-item[<?php echo esc_attr($item_id); ?>]" <?php checked( $show_as_megamenu, true ); ?> />
	</p>
	<p class="description-wide megmenuvancutom">
		<label class="description"><?php esc_html_e( 'Megamenu Select', 'vankine' ); ?>
		<?php
			$pageslist = get_posts(
				array(
					'post_type'      => 'mega_menu',
					'posts_per_page' => -1,
				)
			);
		?>
		<select name="megamenu_select[<?php echo esc_attr($item_id); ?>]" id="megamenu-select">
		<?php
		$megamenu_selected = get_post_meta( $item->ID, 'vankine_megamenu_select', true );
		?>
			<option value=""><?php esc_html_e( 'Select Template', 'vankine' ); ?></option>
			<?php
			if ( ! empty( $pageslist ) ) {
				foreach ( $pageslist as $page ) {
					if ( ! empty( $megamenu_selected ) && $megamenu_selected == $page->ID ) {
						echo '<option selected value="' . esc_attr($page->ID) . '">' . esc_attr($page->post_title) . '</option>';
					} else {
						echo '<option value="' . esc_attr($page->ID) . '">' . esc_attr($page->post_title) . '</option>';
					}
				}
			}
			?>
		</select> 
		</label>
		</p> 
<p><?php echo esc_html_e('To Display Dropdown More Column add numbers in text Like  this (( one , two , three , four , five or full column only )) if megamenu enabled this will not work' , 'vankine') ?></p>
<p class="description-wide vankine_same_call displudroncutom">
	<label class="description"><?php esc_html_e( 'Dropdown Column', 'vankine' ); ?></label>
	<input type="text" id="dropcolumn" name="dropcolumn[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($dropcolumn); ?>" placeholder="<?php esc_attr_e( 'one', 'vankine' ); ?>" />
</p>

	<?php endif; ?> 

<?php if($item->menu_item_parent != '0'): ?>
	
<p  class="image_type_desc"><?php echo esc_html_e('Two type of image style default style is enabled enter ( two ) to display image style two' , 'vankine') ?></p>
<p class="description-wide vankine_same_call image_style_choose">
	<label class="description"><?php esc_html_e( 'Image Type', 'vankine' ); ?></label>
	<input type="text" id="image_style" name="image_style[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($image_style); ?>" placeholder="<?php esc_attr_e( 'one', 'vankine' ); ?>" />
</p>
<?php endif; ?> 
<?php
}
 
add_action('wp_update_nav_menu_item','vankine_update_custom_fields',10,2);
function vankine_update_custom_fields ( $menu_id, $menu_item_db_id ) {
	if ( isset( $_POST['badge_item'][ $menu_item_db_id ] ) && ! empty( $_POST['badge_item'][ $menu_item_db_id ] ) ) {
		update_post_meta( $menu_item_db_id, 'vankine_badge_item', $_POST['badge_item'][ $menu_item_db_id ] );
	} else {
		delete_post_meta( $menu_item_db_id, 'vankine_badge_item' );
	}
	if ( isset( $_POST['image_style'][ $menu_item_db_id ] ) && ! empty( $_POST['image_style'][ $menu_item_db_id ] ) ) {
		update_post_meta( $menu_item_db_id, 'vankine_image_style', $_POST['image_style'][ $menu_item_db_id ] );
	} else {
		delete_post_meta( $menu_item_db_id, 'vankine_image_style' );
	}
	if ( isset( $_POST['dropcolumn'][ $menu_item_db_id ] ) && ! empty( $_POST['dropcolumn'][ $menu_item_db_id ] ) ) {
		update_post_meta( $menu_item_db_id, 'vankine_dropcolumn', $_POST['dropcolumn'][ $menu_item_db_id ] );
	} else {
		delete_post_meta( $menu_item_db_id, 'vankine_dropcolumn' );
	}
	

	$button_value = ( isset( $_POST['megamenu-item'][ $menu_item_db_id ] ) && $_POST['megamenu-item'][ $menu_item_db_id ] == 'on' ) ? true : false;
	update_post_meta( $menu_item_db_id, 'vankine_show-as-megamenu', $button_value );
}

add_filter('nav_menu_css_class','vankine_add_class_for_mega_menu',10,2);
function vankine_add_class_for_mega_menu ( $classes, $menu_item ) {
	if ( $menu_item->menu_item_parent == '0' ) {
		$show_as_megamenu = get_post_meta( $menu_item->ID, 'vankine_show-as-megamenu', true );
		if ( $show_as_megamenu ) {
			$classes[] = 'mega-menu-li dropdown_full position-static mega_menu';
		}
	}
	return $classes;
}
 
add_action( 'wp_update_nav_menu_item', 'vankine_save_megamenu_item', 10, 2 );
function vankine_save_megamenu_item( $menu_id, $menu_item_db_id ) {
	if ( isset( $_POST['megamenu_select'][ $menu_item_db_id ] ) && $_POST['megamenu_select'][ $menu_item_db_id ] != '' ) {
		$sanitized_data = $_POST['megamenu_select'][ $menu_item_db_id ];
		update_post_meta( $menu_item_db_id, 'vankine_megamenu_select', $sanitized_data );
	} else {
		delete_post_meta( $menu_item_db_id, 'vankine_megamenu_select' );
	}
}

add_action('wp_nav_menu_item_custom_fields', 'vankine_custom_field_media', 10, 2);
function vankine_custom_field_media($item_id, $item)
{
    // Get WordPress' media upload URL
    $upload_link = esc_url(get_upload_iframe_src('image', $item->ID));

    // See if there's a media id already saved as post meta
    $your_img_id = get_post_meta($item->ID, 'vankine_get_image', true);

    // Get the image src
    $your_img_src = wp_get_attachment_image_src($your_img_id, 'full');

    // For convenience, see if the array is valid
    $you_have_img = is_array($your_img_src);
    ?>

    <div class="description jt-bg-image-upload-wrapper">
        <!-- Your image container, which can be manipulated with js -->
        <div class="custom-img-container">
            <?php if ($you_have_img) : ?>
                <img src="<?php echo esc_url($your_img_src[0]) ?>" alt="" style="max-width:100%;" />
            <?php endif; ?>
        </div>

        <!-- Your add & remove image links -->
        <p class="hide-if-no-js">
            <a class="upload-custom-img <?php if ($you_have_img) {
                                            echo 'hidden';
                                        } ?>" href="<?php echo esc_url($upload_link) ?>">
                <?php _e('Set custom image', 'vankine') ?>
            </a>
            <a class="delete-custom-img <?php if (!$you_have_img) {
                                            echo 'hidden';
                                        } ?>" href="#">
                <?php _e('Remove this image', 'vankine') ?>
            </a>
        </p>

        <!-- A hidden input to set and post the chosen image id -->
        <input class="vankine-img-menu-id" name="vankine-img-menu-id[<?php echo esc_attr($item->ID); ?>]" type="hidden" value="<?php echo esc_attr($your_img_id); ?>" />
    </div>
<?php
}

add_action('wp_update_nav_menu_item', 'vankine_save_media_field', 10, 3);
function vankine_save_media_field($menu_id, $menu_item_db_id, $menu_item_args)
{
    if (isset($_POST['vankine-img-menu-id'][$menu_item_db_id]) && $_POST['vankine-img-menu-id'][$menu_item_db_id] != '') {
        $value = $_POST['vankine-img-menu-id'][$menu_item_db_id];
        if (!empty($value)) {
            update_post_meta($menu_item_db_id, 'vankine_get_image', $value);
        } else {
            delete_post_meta($menu_item_db_id, 'vankine_get_image');
        }
    } else {
        delete_post_meta($menu_item_db_id, 'vankine_get_image');
    }
}

add_filter('nav_menu_css_class', 'vankine_add_class_for_image', 10, 3);
function vankine_add_class_for_image($classes, $menu_item)
{
    $show_as_image = get_post_meta($menu_item->ID, 'vankine_get_image', true);
    if ($show_as_image) {
        $classes[] = 'vankine_menu_image';
    }
    return $classes;
}
