<?php

namespace  Vankineaddons\Core\Widgets\Post;
if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Portfolio_filter_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-portfoliofilt-v1';
    }
    public function get_title()
    {
        return __('portfolio Filter V1' , 'vankine-addons');
    }
    public function get_icon()
    {
        return 'icon-vankine-icon';
    }
    public function get_categories()
    {
        return ['102'];
    }
    protected function register_controls(){
            $this->start_controls_section(
                'portfolio_set_content',
                [
                    'label' => __('portfolio  Settings', 'vankine-addons')
                ]
            );
            $this->add_control(
                'portfolio_style',
                [
                    'label' => __('portfolio style', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::SELECT,
                    'options' => [

                        'style_one'  => __('Style One ', 'vankine-addons'),
                        'style_two' => __('Style Two ', 'vankine-addons'),
                    ],
                    'default' => 'style_one',
                ]
            );
            $this->add_control(
                'column',
                [
                    'label' => __('Column', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'col-xl-3 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Four Column', 'vankine-addons' ),
                        'col-xl-4 col-lg-4 col-md-6 col-sm-6'   => esc_html__( 'Three Column', 'vankine-addons' ),
                        'col-xl-6 col-lg-6 col-md-6 col-sm-6'   => esc_html__( 'Two Column', 'vankine-addons' ),
                        'col-xl-12'   => esc_html__( 'One Column', 'vankine-addons' ),
                    ],
                    'default' => 'col-xl-3 col-lg-4 col-md-6 col-sm-6',
                
                ]
            );
            $this->add_control(
                'hide_filter_tab',
                [
                    'label' => __('Filter Tab Enable / Disable', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', 'vankine-addons'),
                    'label_off' => __('No', 'vankine-addons'),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
          
            $this->add_control(
                'post_count',
            [
        
                'label'   => esc_html__( 'Number of post', 'vankine-addons' ),
                'type'    =>  \Elementor\Controls_Manager::NUMBER,
                'default' => 1,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]);
            $this->add_control(
                'text_limits',
                [
                    'label'   => esc_html__( 'Text Limit', 'vankine-addons' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 12,
                    'min'     => 1,
                    'max'     => 100,
                    'step'    => 1,
                ]
            );
            $this->add_control(
                'query_orderby',
                [
                    'label'   => esc_html__( 'Order By', 'vankine-addons' ),
                    'type'    =>  \Elementor\Controls_Manager::SELECT,
                    'default' => '',
                    'options' => array(
                        ''       => esc_html__( 'Select', 'vankine-addons' ),
                        'date'       => esc_html__( 'Date', 'vankine-addons' ),
                        'title'      => esc_html__( 'Title', 'vankine-addons' ),
                        'menu_order' => esc_html__( 'Menu Order', 'vankine-addons' ),
                        'rand'       => esc_html__( 'Random', 'vankine-addons' ),
                    ),
                ]
            );
            $this->add_control(
                'query_order',
                [
                    'label'   => esc_html__( 'Order', 'vankine-addons' ),
                    'type'    =>  \Elementor\Controls_Manager::SELECT,
                    'default' => '',
                    'options' => array(
                        '' => esc_html__( 'Select', 'vankine-addons' ),
                        'DESC' => esc_html__( 'DESC', 'vankine-addons' ),
                        'ASC'  => esc_html__( 'ASC', 'vankine-addons' ),
                    ),
                ]
            );
            $this->add_control(
                'ajax_loadmore',
               [
                  'label' => __('Ajax Load More Enable', 'vankine-addons'),
                   'type' => \Elementor\Controls_Manager::SWITCHER,
                   'label_on' => __('Yes', 'vankine-addons'),
                   'label_off' => __('No', 'vankine-addons'),
                   'return_value' => 'yes',
                   'default' => 'yes',
               ]
            );
            $this->add_control(
                'load_more',
                [
                    'label' => __( 'Load More', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __( 'Load More', 'vankine-addons' ),
                    'condition' => [
                        'ajax_loadmore' => 'yes'
                   ],
                ]
            );
            $this->add_control(
                'pagination_enable',
               [
                  'label' => __('Pagination Enable', 'vankine-addons'),
                   'type' => \Elementor\Controls_Manager::SWITCHER,
                   'label_on' => __('Yes', 'vankine-addons'),
                   'label_off' => __('No', 'vankine-addons'),
                   'return_value' => 'yes',
                   'default' => 'yes',
               ]
            );
           
            $this->add_responsive_control(
                'pagination_alignment',
                [
                    'label' => __('Pagination alignments', 'vankine-addons'),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                      'left' => [
                        'title' => __( 'Pagination Left', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-left',
                      ],
                      'center' => [
                        'title' => __( 'Pagination Center', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-center',
                      ],
                      'right' => [
                        'title' => __( 'Pagination Right', 'vankine-addons' ),
                        'icon' => 'eicon-text-align-right',
                      ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                      '{{WRAPPER}} .pagination_blog ' => 'text-align: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'pagination_enable' => 'yes'
                   ],
                ]
            );
    
    
            $this->add_control(
                'hrp',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                    'condition' => [
                        'pagination_enable' => 'yes'
                    ],
                ]
            );
    
            $this->add_control(
                'pagcolor',
                [
                    'label' => __('Pagination Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .pagination li a.page-link , {{WRAPPER}}   .pagination li .page-numbers , {{WRAPPER}}  .page-numbers li a.page-link , {{WRAPPER}}  .page-numbers li .page-numbers  ' => 'color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'pagination_enable' => 'yes',
                    ]
                ]
            );
    
            $this->add_control(
                'pagacolor',
                [
                    'label' => __('Pagination Active Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .pagination li span.current , {{WRAPPER}}  .page-numbers li span.current , {{WRAPPER}}  .pagination li span:hover , {{WRAPPER}}  .page-numbers li span:hover ' => 'color: {{VALUE}}!important; text-decoration-color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'pagination_enable' => 'yes',
                    ]
                ]
            );
    
            $this->add_control(
                'pagnxticoncolor',
                [
                    'label' => __('Pagination Next / Prev  Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'pagination_enable' => 'yes',
                    ]
                ]
            );
    
            $this->add_control(
                'pagnxtpreviconcolor',
                [
                    'label' => __('Pagination Next / Prev Border Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'border-color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'pagination_enable' => 'yes',
                    ]
                ]
            );
    
            $this->add_control(
                'pagnxtbgcolor',
                [
                    'label' => __('Pagination Next / Prev Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination li.next_link a , {{WRAPPER}} .pagination li.prev_link a , {{WRAPPER}} .pagination li a.next , {{WRAPPER}} .pagination li a.prev , {{WRAPPER}} .page-numbers li.next_link a , {{WRAPPER}} .page-numbers li.prev_link a , {{WRAPPER}} .page-numbers li a.next , {{WRAPPER}} .page-numbers li a.prev ' => 'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'pagination_enable' => 'yes',
                    ]
                ]
            );
    
           
    
            $this->add_control(
                'hr',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
               
            $this->add_control(
                'load_more_color',
                [
                    'label' => __('Load More Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination .theme_btn  ' => 'color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'load_morebg_color',
                [
                    'label' => __('Load More Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination .theme_btn  ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
    
    
            $this->add_control(
                'load_ho_more_color',
                [
                    'label' => __('Load More Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'loadho_morebg_color',
                [
                    'label' => __('Load More Hover Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pagination .theme_btn:hover  ' => 'background: {{VALUE}}!important; border-color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'ajax_loadmore' => 'yes',
                    ]
                ]
            );
 
            $this->end_controls_section();
            $this->start_controls_section('portfoliofilt_box_css',
            [ 
                'label' => __('Filter Tab Css', 'vankine-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
            );
            $this->add_responsive_control(
                'filter_alignment',
                [
                    'label' => esc_html__( 'Filter Alignment', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'options' => [
                        'start' => [
                            'title' => esc_html__( 'Left', 'vankine-addons' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'vankine-addons' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'end' => [
                            'title' => esc_html__( 'Right', 'vankine-addons' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .fliter_group ' => 'text-align: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'filter_color',
                [
                    'label' => __('Filter Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .fliter_group li   ' => 'color: {{VALUE}}!important;',
                    ],
                ]
            );
           
          
            
            $this->add_control(
                'hrsvnfilt',
                [
                    'type' =>  \Elementor\Controls_Manager::DIVIDER,
                ] 
            );
            $this->add_control(
                'filter_color_hover',
                [
                    'label' => __('Filter Hover / Active Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                     'selectors' => [
                        '{{WRAPPER}} .fliter_group li:hover , {{WRAPPER}} .fliter_group li.current ' => 'color: {{VALUE}}!important;',
                      ],
                ]
            );
            $this->add_control(
                'filter_color_hover_bg',
                [
                    'label' => __(' Filter  Hover / Active Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                     'selectors' => [
                        '{{WRAPPER}} .fliter_group li:hover , {{WRAPPER}} .fliter_group li.current ' => 'background: {{VALUE}}!important;',
                      ],
                ]
            );


     
          
            $this->end_controls_section();
            $this->start_controls_section('custom_css',
            [ 
                'label' => __('Custom Css', 'vankine-addons'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
            );
            $this->add_group_control(
                \Elementor\Group_Control_Border::get_type(),
                [
                    'name' => 'borderpro',
                    'selector' => '{{WRAPPER}} .portfolio_box.type_one .image_box , {{WRAPPER}} .portfolio_box.type_two  ',
                ]
            );
            

            $this->add_control(
                'titles_color',
                [
                    'label' => __('Title Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one .title_22 a , {{WRAPPER}} .portfolio_box.type_two .title_30  a ,  {{WRAPPER}} .portfolio_box.type_one .title_22 a span:after , {{WRAPPER}} .portfolio_box.type_two .title_30  a span:after ' => 'color: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'desc_color',
                [
                    'label' => __('Description Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_two .content_box p , {{WRAPPER}} .portfolio_box.type_one .content_box  p   ' => 'color: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'zoom_icon_color',
                [
                    'label' => __('Zoom Icon Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .zm_btn  ' => 'color: {{VALUE}}!important;',
                    ],

                ]
            );
            $this->add_control(
                'zoom_icon_bg_color',
                [
                    'label' => __('Zoom Icon Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .zm_btn  ' => 'background: {{VALUE}}!important;',
                    ],

                ]
            );
            $this->add_control(
                'read_more_color',
                [
                    'label' => __('Link Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .lnk svg path ' => 'stroke: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'read_morebg_color',
                [
                    'label' => __('Link Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .lnk ' => 'background: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'over_lay_color',
                [
                    'label' => __('Overlay Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}}  .portfolio_box .hover_1 .oh , {{WRAPPER}} .portfolio_box.type_two .bg ' => 'background: {{VALUE}}!important;',
                    ],
                ]
            );
            $this->add_control(
                'box_bg',
                [
                    'label' => __('Box Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one .content_box .content_box_in' =>  'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one', 
                    ]
                ]
            );

            $this->add_control(
                'hrsvn',
                [
                    'type' =>  \Elementor\Controls_Manager::DIVIDER,
                
                ]
            );
            $this->add_control(
                'portfolios_image_height',
                [
                    'label' => esc_html__( 'portfolio Image Height', 'vankine-addons' ),
                    'type' => \Elementor\Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 2000,
                    'step' => 1,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box .image_box img ' => 'height: {{VALUE}}px!important;',
                    ],
                ]
            );
            $this->add_control(
                'hrsix',
                [
                    'type' =>  \Elementor\Controls_Manager::DIVIDER,
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );

            $this->add_control(
                'header_hos_color',
                [
                    'label' => __('Heading Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .title_22 a , {{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .title_22 a span:after  ' => 'color:{{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ],
                ]
            );
            $this->add_control(
                'desc_ho_color',
                [
                    'label' => __('Description Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in p ' => 'color: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );
            $this->add_control(
                'box_hov_color',
                [
                    'label' => __('Box Bg Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in ' => 'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );
            $this->add_control(
                'link_ho_color',
                [
                    'label' => __('Link Hover Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .lnk svg path ' => 'stroke: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );
            $this->add_control(
                'link_bg_ho_color',
                [
                    'label' => __('Link Hove Bg Color', 'vankine-addons'),
                    'type' =>  \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .portfolio_box.type_one:hover .content_box .content_box_in .lnk ' => 'background: {{VALUE}}!important;',
                    ],
                    'condition' => [
                        'portfolio_style' => 'style_one',
                    ]
                ]
            );


            
            $this->end_controls_section();
    }
protected function render(){
$settings = $this->get_settings_for_display();
?>

<section class="portfolio_v1 portfolio_tabs <?php if($settings['ajax_loadmore'] == 'yes'): ?> ajax_protfolio_enabled <?php endif; ?>">
    <?php if($settings['hide_filter_tab'] == 'yes'):
        $taxonomy = 'portfolio_category';
        $terms = get_terms($taxonomy); // Get all terms of a taxonomy
        if($terms && !is_wp_error($terms)):
        ?>
    <div class="row">
        <div class="col-sm-12">
            <div class="fliter_group">
                <ul class="portfolio_filter clearfix">
                    <li data-filter="*" class="current trans">
                        <?php echo esc_html('view All'); ?></li>

                    <?php foreach ( $terms as $term ) { ?>
                    <li class="trans" data-filter=".portfolio_category-<?php echo ($term->slug); ?>"><?php echo $term->name; ?></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
    <?php endif;?>
    <?php endif;?>
    <div class="portfoliocontainer row">
        <?php if ( get_query_var( 'paged' ) ) { 
                $paged = get_query_var( 'paged' ); 
              } elseif ( get_query_var( 'page' ) ) { 
                $paged = get_query_var( 'page' ); 
              } else { 
                $paged = 1; 
              }
        $args = array(
            'post_type' => 'portfolio',
            'ignore_sticky_posts' => true,
            'paged'             => $paged,
            'posts_per_page' => $settings['post_count'],
            'orderby'        => $settings['query_orderby'],
            'order'          =>  $settings['query_order'],
        );
        $query = new \WP_Query( $args );
        if($query->have_posts()):	
        while ( $query->have_posts() ) : $query->the_post();
        $post_terms = wp_get_post_terms( get_the_id(), 'portfolio_category'); 
        $portfolio_category = 'portfolio_category';
        $term_slug = '';
        if($post_terms) foreach($post_terms as $p_term) $term_slug .= $portfolio_category . '-' . $p_term->slug.' ';
        ?>
        <div class="portfolio-wrapper <?php echo esc_attr($settings['column']); ?> <?php echo esc_attr($term_slug); ?>">
        <?php if($settings['portfolio_style'] == 'style_one'):?>
            <div class="portfolio_box type_one hover_1_get">
                <div class="image_box hover_1">
                    <?php the_post_thumbnail(); ?>
                    <a data-fancybox="gallery" class="zm_btn trans"
                        href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">
                        <span class="fi-rs-cursor-plus zoom_icon"></span>
                    </a>
                    <div class="oh ho_1"></div>
                    <div class="oh ho_2"></div>
                    <div class="oh ho_3"></div>
                    <div class="oh ho_4"></div>
                </div>
                <div class="content_box">
                    <div class="content_box_in  trans">
                        <?php the_title( '<h2 class="title_22"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
                        <?php $excerpt = '';
                        if (has_excerpt()): ?>
                            <p>
                            <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                echo esc_attr($excerpt);
                            ?>
                            </p> 
                        <?php endif; ?>
                        <a href="<?php echo esc_url(get_permalink()); ?>" class="lnk trans">
                            <svg class="trans" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 7.75H16M16 7.75L9.25 1M16 7.75L9.25 14.5" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        <?php elseif($settings['portfolio_style'] == 'style_two'): ?>
            <div class="portfolio_box type_two">
                <div class="image_box ">
                    <?php the_post_thumbnail(); ?>
                    <a data-fancybox="gallery" class="zm_btn trans"
                        href="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>">
                        <span class="fi-rs-cursor-plus zoom_icon"></span>
                    </a>
                </div>
         
                 
                <div class="content_box  trans">
                <div class="bg trans"></div>
                    <div class="con">
                        <?php the_title( '<h2 class="title_30"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>' ); ?>
                        <?php $excerpt = '';
                        if (has_excerpt()): ?>
                            <p>
                            <?php $excerpt = wp_strip_all_tags(wp_trim_words(get_the_excerpt() , $settings['text_limits']));
                                echo esc_attr($excerpt);
                            ?>
                            </p> 
                        <?php endif; ?>
                    </div>
                    <a href="<?php echo esc_url(get_permalink()); ?>" class="lnk trans">
                        <svg class="trans" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1 7.75H16M16 7.75L9.25 1M16 7.75L9.25 14.5" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                </div>
            </div>
        <?php endif; ?>
        </div>
        <?php endwhile; ?>
    <?php endif;?>
    <?php wp_reset_postdata(); ?>
</div>

<?php if($settings['pagination_enable'] == 'yes' || $settings['ajax_loadmore'] == 'yes'):?>
    <div class="row">
        <div class="col-lg-12">
            <div class="pagination text-center">
                <?php
                    if($settings['ajax_loadmore'] == 'yes'):
                        $prev = '';
                        $next = '<span class="theme_btn">'.$settings['load_more'].'</span>';
                        $type = 'plain';
                    elseif($settings['pagination_enable'] == 'yes'):
                        $prev = '<i class="fa fa-angle-left"></i>';
                        $next = '<i class="fa fa-angle-right"></i>';
                        $type = 'list';
                    endif;


                    $pagination = 999999999;
                    echo paginate_links( array(
                            'base' => str_replace( $pagination, '%#%', get_pagenum_link( $pagination ) ),
                            'format' => '?paged=%#%',
                             'current' => max(0, $paged),
                            'total' => $query->max_num_pages,
                            'prev_text' => $prev,
                            'next_text' => $next,
                            'type'=> $type, 
                            'add_args' => false
                    ) );
                     
                ?>          
            </div>
        </div>
    </div>
    <?php endif; ?>

  
			
</section>

<?php
    }
}