<?php

namespace  Vankineaddons\Core\Widgets\Footer;
if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Foo_contact_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-footer-contact';
    }

    public function get_title()
    {
        return __('Footer Contact  V1' , 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['104'];
    }

    protected function register_controls(){

        $this->start_controls_section('footer_contact_content',
        [ 
            'label' => __('Contact Content', 'vankine-addons')
        ]
        );
     

        $this->add_control(
            'contact_type',
            [
                'label' => __('Contact Type', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'address_type' => __('Address', 'vankine-addons'),
                    'phone_type' => __('Phone', 'vankine-addons'),
                    'mail_type' => __('Mail', 'vankine-addons'),
                    'timing_type' => __('Timing', 'vankine-addons'),
                ],
                'default' => 'address_type',
            ]
        );
 
        $this->add_control(
            'heading_text',
            [
                'label' => __('Heading', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default text', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
              
            ]
        );

        $this->add_control(
            'address',
            [
                'label' => __(' Address', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('United States 866 Wilshire, 2nd Street Los Angeles 90024.', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
                'condition' => [
                    'contact_type' => 'address_type',
                ]
            ]
        );

        $this->add_control(
            'phone',
            [
                'label' => __('Phone', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('+555 5678 12340', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
                'condition' => [
                    'contact_type' => 'phone_type',
                ]
            ]
        );
   
        $this->add_control(
            'mail',
            [
                'label' => __(' Mail Id', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('support@vankine.com', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
                'condition' => [
                    'contact_type' => 'mail_type',
                ]
            ]
        );
   
        $this->add_control(
            'timing',
            [
                'label' => __(' Timing', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Mon - Sat: 09.00 to 06.00 (Sun:Closed)', 'vankine-addons'),
                'placeholder' => __('Type your text here', 'vankine-addons'),
                'condition' => [
                    'contact_type' => 'timing_type',
                ]
            ]
        );
    

        $this->end_controls_section();
 

        $this->start_controls_section('button_css',
        [ 
            'label' => __('Custom Css ', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
        );
        $this->add_responsive_control(
            'icon_move_top',
            [
                'label' => __('Icon Move Top', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 2,
                'min'     => -150,
                'max'     => 150,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .footer_contact_widget svg  ' => 'top: {{VALUE}}px!important;', 
                ],
            ]
        );
        $this->add_control(
            'icon_olor',
             [
                'label' => __('Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
					'{{WRAPPER}} .footer_contact_widget svg path.strokse ' => 'stroke: {{VALUE}}!important',
                    '{{WRAPPER}} .footer_contact_widget svg path.pathtwo ' => 'fill: {{VALUE}}!important',
				], 
             ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Title Typo', 'vankine-addons' ),
				'name' => 'title_typo',
				'selector' => '{{WRAPPER}} .footer_contact_widget .title_no_a1_8 ',
			]
		);
     

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
                'label' => esc_html__( 'Content Typo', 'vankine-addons' ),
				'name' => 'content_typo',
				'selector' => '{{WRAPPER}} .footer_contact_widget .d-flex p , {{WRAPPER}} .footer_contact_widget .d-flex p a ',
			]
		);
        $this->add_control(
            'title_color',
             [
                'label' => __('Content Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
					'{{WRAPPER}} .footer_contact_widget .title_no_a1_8 ' => 'color: {{VALUE}}!important',
                    'pathtwo'
				], 
             ]
        );
        $this->add_control(
            'content_text_color',
             [
                'label' => __('Content Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                 'selectors' => [
					'{{WRAPPER}} .footer_contact_widget .d-flex p , {{WRAPPER}} .footer_contact_widget .d-flex p a ' => 'color: {{VALUE}}!important',
                    'pathtwo'
				], 
             ]
        );

         
        $this->end_controls_section();
       
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
      
        $allowed_tags = wp_kses_allowed_html('post');
        ?> 
     
     <div class="footer_contact_widget"> 
                   
				    <?php if($settings['contact_type'] == 'phone_type') : ?> 
					<div class="d-flex">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path class="strokse" d="M20.25 3.75V8.25M20.25 3.75H15.75M20.25 3.75L14.25 9.75M17.25 21.75C8.966 21.75 2.25 15.034 2.25 6.75V4.5C2.25 3.90326 2.48705 3.33097 2.90901 2.90901C3.33097 2.48705 3.90326 2.25 4.5 2.25H5.872C6.388 2.25 6.838 2.601 6.963 3.102L8.069 7.525C8.179 7.965 8.015 8.427 7.652 8.698L6.359 9.668C6.17393 9.80198 6.037 9.99207 5.96854 10.21C5.90009 10.428 5.90375 10.6623 5.979 10.878C6.58087 12.5151 7.53141 14.0018 8.76478 15.2352C9.99815 16.4686 11.4849 17.4191 13.122 18.021C13.563 18.183 14.05 18.017 14.332 17.641L15.302 16.348C15.4348 16.1708 15.6169 16.0366 15.8256 15.9625C16.0342 15.8883 16.2601 15.8773 16.475 15.931L20.898 17.037C21.398 17.162 21.75 17.612 21.75 18.128V19.5C21.75 20.0967 21.5129 20.669 21.091 21.091C20.669 21.5129 20.0967 21.75 19.5 21.75H17.25V21.75Z" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <div>
                        <?php if(!empty($settings['heading_text'])) : ?> 
                       <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
						<?php endif; ?>
                        <p><a href="tel:<?php echo wp_kses($settings['phone'] , $allowed_tags); ?>"><?php echo wp_kses($settings['phone'], $allowed_tags); ?></a></p>
                        </div>
                    </div>
                    <?php elseif($settings['contact_type'] == 'mail_type'): ?> 
					<div class="d-flex">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path class="strokse" d="M21.75 6.75V17.25C21.75 17.8467 21.5129 18.419 21.091 18.841C20.669 19.2629 20.0967 19.5 19.5 19.5H4.5C3.90326 19.5 3.33097 19.2629 2.90901 18.841C2.48705 18.419 2.25 17.8467 2.25 17.25V6.75M21.75 6.75C21.75 6.15326 21.5129 5.58097 21.091 5.15901C20.669 4.73705 20.0967 4.5 19.5 4.5H4.5C3.90326 4.5 3.33097 4.73705 2.90901 5.15901C2.48705 5.58097 2.25 6.15326 2.25 6.75M21.75 6.75V6.993C21.75 7.37715 21.6517 7.75491 21.4644 8.0903C21.2771 8.42569 21.0071 8.70754 20.68 8.909L13.18 13.524C12.8252 13.7425 12.4167 13.8582 12 13.8582C11.5833 13.8582 11.1748 13.7425 10.82 13.524L3.32 8.91C2.99292 8.70854 2.72287 8.42669 2.53557 8.0913C2.34827 7.75591 2.24996 7.37815 2.25 6.994V6.75" stroke="#008BF9" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <div>
                        <?php if(!empty($settings['heading_text'])) : ?> 
                       <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
						<?php endif; ?>
                        <p><a href="mailto:<?php echo wp_kses($settings['mail'] , $allowed_tags); ?>"><?php echo wp_kses($settings['mail'], $allowed_tags); ?></a></p>
                        </div>
                    </div>
                    <?php elseif($settings['contact_type'] == 'address_type') : ?> 
					<div class="d-flex">
                        <svg width="21" height="25" viewBox="0 0 21 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path class="strokse" d="M19.75 10.375C19.75 19.3025 10.375 24.4375 10.375 24.4375C10.375 24.4375 1 19.3025 1 10.375C1 7.8886 1.98772 5.50403 3.74587 3.74587C5.50403 1.98772 7.8886 1 10.375 1C12.8614 1 15.246 1.98772 17.0041 3.74587C18.7623 5.50403 19.75 7.8886 19.75 10.375V10.375Z" stroke="#008BF9" stroke-linecap="round" stroke-linejoin="round"/>
                            <path class="pathtwo" d="M14.125 10.375C14.125 11.3696 13.7299 12.3234 13.0267 13.0267C12.3234 13.7299 11.3696 14.125 10.375 14.125C9.38044 14.125 8.42661 13.7299 7.72335 13.0267C7.02009 12.3234 6.625 11.3696 6.625 10.375C6.625 9.38044 7.02009 8.42661 7.72335 7.72335C8.42661 7.02009 9.38044 6.625 10.375 6.625C11.3696 6.625 12.3234 7.02009 13.0267 7.72335C13.7299 8.42661 14.125 9.38044 14.125 10.375Z" fill="#008BF9"/>
                        </svg>
                        <div>
                        <?php if(!empty($settings['heading_text'])) : ?> 
                       <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
						<?php endif; ?>
                        <p><?php echo wp_kses($settings['address'] , $allowed_tags); ?></p>
                        </div>
                    </div>
                    <?php elseif($settings['contact_type'] == 'timing_type'): ?> 
					<div class="d-flex">
                        <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path class="strokse" d="M12 4.75V12.25H17.625M23.25 12.25C23.25 13.7274 22.959 15.1903 22.3936 16.5552C21.8283 17.9201 20.9996 19.1603 19.955 20.205C18.9103 21.2496 17.6701 22.0783 16.3052 22.6436C14.9403 23.209 13.4774 23.5 12 23.5C10.5226 23.5 9.05972 23.209 7.69481 22.6436C6.3299 22.0783 5.08971 21.2496 4.04505 20.205C3.00039 19.1603 2.17172 17.9201 1.60636 16.5552C1.04099 15.1903 0.75 13.7274 0.75 12.25C0.75 9.26631 1.93526 6.40483 4.04505 4.29505C6.15483 2.18526 9.01631 1 12 1C14.9837 1 17.8452 2.18526 19.955 4.29505C22.0647 6.40483 23.25 9.26631 23.25 12.25Z" stroke="#008BF9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <div>
                        <?php if(!empty($settings['heading_text'])) : ?> 
                       <h6 class="title_no_a1_8"><?php echo wp_kses($settings['heading_text'] , $allowed_tags); ?></h6>
						<?php endif; ?>
                        <p><?php echo wp_kses($settings['timing'] , $allowed_tags); ?></p>
                    </div>
                    </div>
					<?php endif; ?>
			</div>
            
        <?php
    }
}



