<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Fun_facts_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-fun-facts-v1';
    }

    public function get_title()
    {
        return __('Funfacts V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('funfacts_content_v1_settings',
        [ 
            'label' => __('Funfacts Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'funfacts_style',
            [
            'label' => __('Funfacts Styles', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'style_one' => __( 'Style One', 'vankine-addons' ),
                'style_two' => __( 'Style Two', 'vankine-addons' ),
                'style_three' => __( 'Style Three', 'vankine-addons' ),
                'style_four' => __( 'Style Four', 'vankine-addons' ),
            ],
            'default' => 'style_one' , 
            ]
        );

        $this->add_control(
            'icon_enable',
            [
                'label' => esc_html__( 'Icon Enable  / Disable', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        
        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'image' => esc_html__( 'Image', 'vankine-addons' ),
					'icon'  => esc_html__( 'Icon', 'vankine-addons' ), 
				], 
                'default' =>  'icon' ,  
			]
		);
        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $this->add_control(
            'switcher_c_icon',
            [
                'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'icon_type' => 'icon'
                ],
            ]
        );
        
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                'condition' => [
                    'switcher_c_icon' => 'yes' ,
                    'icon_type' => 'icon'
                ]
            ]
        );
        $this->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [
                    'switcher_c_icon' => '',
                    'icon_type' => 'icon'
                ]
            ]
        );
          
        $this->add_control(
            'number',
            [
              'label' => __('Count', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('545', 'vankine-addons'),
              'placeholder' => __('Type your text here', 'vankine-addons'),
            ]
        );

        $this->add_control(
            'symbol',
            [
              'label' => __('Symbol', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::TEXT,
              'default' => __('+', 'vankine-addons'),
              'placeholder' => __('Type your Symbols here', 'vankine-addons'),
            ]
        );
 
        $this->add_control(
          'title',
          [
             'label' => __('Title', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Helath Insurance', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );
         
    $this->end_controls_section();

    $this->start_controls_section('custom_css',
    [ 
        'label' => __('Custom Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );

    
    $this->add_control(
        'icon_bg_color',
         [
            'label' => __('Icon Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts.type_one .icon .icon_in ' => 'background: {{VALUE}}!important;',
            ],
            'condition' => [
                'funfacts_style' => 'style_one', 
            ],
         ]
    );
    $this->add_control(
        'icon_color',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts .icon  i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'icon_hover_bor_color',
         [
            'label' => __('Icon Hover Border Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts.type_one:hover .icon ' => 'border-color: {{VALUE}}!important;',
            ],
            'condition' => [
                'funfacts_style' => 'style_one', 
            ],
         ]
    );
   
    $this->add_control(
        'count_color',
         [
            'label' => __('Count Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts.type_one h4 span  , {{WRAPPER}} .fun_facts.type_three h4 span ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'count_sym_color',
         [
            'label' => __('Count Symbol Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts.type_one h4 small , {{WRAPPER}} .fun_facts.type_three h4 small ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_control(
        'title_color',
         [
            'label' => __('Title Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts .title_no_a_18 , {{WRAPPER}} .fun_facts .title_no_a_18 span:after  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    ); 

    
    $this->add_control(
        'box_bg',
         [
            'label' => __('Bg Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .fun_facts.type_two , {{WRAPPER}} .fun_facts.type_four  ' => 'background: {{VALUE}}!important;',
            ],
         ]
    ); 
    $this->end_controls_section();

    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
     ?>
        
    <?php // style ?>
    <?php if($settings['funfacts_style'] == 'style_two'):  ?>
    <?php // style ?>
    <div class="fun_facts type_two">
        <?php if($settings['icon_enable'] == 'yes'): ?>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
           
                    <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                    <?php endif; ?>	
            <?php endif; ?>
        <?php endif; ?>
            <h4>
                <span class="count">
                    <?php echo esc_attr($settings['number']) ?>
                </span>
                <small>
                    <?php echo esc_attr($settings['symbol']) ?>
                </small>
            </h4>
            <?php if(!empty($settings['title'])): ?>
                <h6 class="title_no_a_26"><?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
    </div>
    <?php // style ?>
    <?php elseif($settings['funfacts_style'] == 'style_three'):  ?>
    <?php // style ?>
    <div class="fun_facts type_three">
        <?php if($settings['icon_enable'] == 'yes'): ?>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                    <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                <?php endif; ?>	
            <?php endif; ?>
        <?php endif; ?>
        <div class="content">
            <h4>
                <span class="count">
                    <?php echo esc_attr($settings['number']) ?>
                </span>
                <small>
                    <?php echo esc_attr($settings['symbol']) ?>
                </small>
            </h4>
            <?php if(!empty($settings['title'])): ?>
                <h6 class="title_no_a_18"><?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
    </div>
    </div>
    <?php // style ?>
    <?php elseif($settings['funfacts_style'] == 'style_four'):  ?>
    <?php // style ?>
    <div class="fun_facts type_four">
        <?php if($settings['icon_enable'] == 'yes'): ?>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                    <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                            </div>
                        <?php endif; ?>	
                <?php endif; ?>	
            <?php endif; ?>
        <?php endif; ?>
            <h4>
                <span class="count">
                    <?php echo esc_attr($settings['number']) ?>
                </span>
                <small>
                    <?php echo esc_attr($settings['symbol']) ?>
                </small>
            </h4>
            <?php if(!empty($settings['title'])): ?>
                <h6 class="title_no_a_18"><?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
    </div>
    <?php else: ?>

        <div class="fun_facts type_one">
        <?php if($settings['icon_enable'] == 'yes'): ?>
            <?php if($settings['icon_type'] == 'image'): ?>
                <?php if(!empty($settings['image']['url'])): ?>
                    <div class="icon trans">
                        <div class="icon_in trans">
                            <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="img" />
                        </div>
                    </div>
                <?php endif; ?>
            <?php elseif($settings['icon_type'] == 'icon'): ?>
                    <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <div class="icon trans">
                                <div class="icon_in trans">
                                <i class="<?php echo esc_attr($settings['icon']); ?>"></i>
                                </div>
                            </div>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <div class="icon trans">
                                <div class="icon_in trans">
                                    <?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                                </div>
                            </div>
                        <?php endif; ?>	
                <?php endif; ?>	
            <?php endif; ?>
        <?php endif; ?>
            <h4>
                <span class="count">
                    <?php echo esc_attr($settings['number']) ?>
                </span>
                <small>
                    <?php echo esc_attr($settings['symbol']) ?>
                </small>
            </h4>
            <?php if(!empty($settings['title'])): ?>
                <h6 class="title_no_a_18"><?php echo wp_kses($settings['title'] , $allowed_tags); ?></h6>
            <?php endif; ?>
    </div>

    <?php // style ?>
    <?php endif; ?>
    <?php // style ?>


    <?php
    }
}

 

