<?php

return array(
	'id'     => 'vankine_header_settings',
	'title'  => esc_html__( "General Settings", "vankine-addons" ),
	'fields' => array(

		array(
			'id'       => 'metaborder_enable',
			'type'     => 'switch',
			'title'    => esc_html__( 'Border Line Enable', 'vankine-addons' ),
            'desc'    => esc_html__( 'Enable Border Line For This Page', 'vankine-addons' ),
			'default'  => false,
		),
		  
		array(
			'id'       => 'body_padding_enable',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable Body Padding Css', 'vankine-addons' ),
			'default'  => false,
		),
		array(
			'id'       => 'padding_for_body',
			'type'     => 'text',
			'title'    =>  esc_html__('Padding For Body (Desktop)', 'vankine-addons') ,
			'placeholder' => esc_html__('0px 0px 0px 0px', 'vankine-addons') ,
            'desc' => esc_html__('Padding option for body  top right botton left  eg(10px 20px 10px 20px)', 'vankine-addons') ,
			'required' => array( 'body_padding_enable', '=', true ),
		),
		array(
			'id'       => 'padding_for_body_mb',
			'type'     => 'text',
			'title'    =>  esc_html__('Padding For Body (Mobile)', 'vankine-addons') ,
			'placeholder' => esc_html__('0px 0px 0px 0px', 'vankine-addons') ,
			'desc' => esc_html__('Padding option for body  top right botton left  eg(10px 20px 10px 20px)', 'vankine-addons') ,
			'required' => array( 'body_padding_enable', '=', true ),
		),

		array(
			'id'    => 'bg_image_or_color',
			'type'  => 'select',
			'title' => esc_html__( 'Choose Background Type', 'vankine-addons' ),
			'options' => array(
				'' => esc_html('Select Background Type' , 'vankine-addons'),
				'background_image' => esc_html('Background Image' , 'vankine-addons'),
                'background_color' => esc_html('Background Color' , 'vankine-addons'),
			),
			'default'  => 'background_image',
			'required' => array( 'body_padding_enable', '=', true ),
		),

		array(
			'id'       => 'body_bg_image',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'vankine-addons' ),
			'desc'     => esc_html__( 'Insert Background Image for Body', 'vankine-addons' ),
			'required' => array( 'bg_image_or_color', '=', 'background_image' ),
		),

		array(
			'title'          => 'Background  Color',
			'id'            => 'body_bg_color',
			'type'          => 'color',
			'required' => array( 'page_header_enable_disable', '=', false ),
			'required' => array( 'bg_image_or_color', '=', 'background_color' ),
		),
 

		
		array(
			'id'       => 'custom_header',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable Header Style', 'vankine-addons' ),
			'default'  => false,
		),
		array(
			'id'    => 'header_settings_meta',
			'type'  => 'select',
			'title' => esc_html__( 'Choose Header Style', 'vankine-addons' ),
			'options' => vankine_common_query('header'),
			'required' => array( 'custom_header', '=', true ),
		),
		array(
			'id'       => 'one_page_header_enable',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable One Page Mobile Menu On Click Close', 'vankine-addons' ),
			'default'  => false,
		),
		 

		array(
			'id'       => 'custom_sticky_header',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable Sticky Header Style', 'vankine-addons' ),
			'default'  => false,
		),
		array(
			'id'    => 'sticky_header_settings_meta',
			'type'  => 'select',
			'title' => esc_html__( 'Choose Sticky Header Style', 'vankine-addons' ),
			'options' => vankine_common_query('header'),
			'required' => array( 'custom_sticky_header', '=', true ),
		),
		
		array(
			'id'       => 'custom_footer',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable Footer Style', 'vankine-addons' ),
			'default'  => false,
		),
		array(
			'id'    => 'footer_settings_meta',
			'type'  => 'select',
			'title' => esc_html__( 'Choose Footer Style', 'vankine-addons' ),
			'options' => vankine_common_query('footer'),
			'required' => array( 'custom_footer', '=', true ),
		),

		array(
			'id'       => 'custom_layout',
			'type'     => 'switch',
			'title'    => esc_html__( 'Enable Custom Layout', 'vankine-addons' ),
			'default'  => false,
		),
		array(
			'title' => esc_html__('Choose Layout', 'vankine-addons') ,
			'id' => 'layout',
			'type' => 'image_select',
			'options' => array(
				'no-sidebar' => get_template_directory_uri() . '/assets/images/full-width.png',
				'right-sidebar' => get_template_directory_uri() . '/assets/images/right-sidebar.png',
				'left-sidebar' => get_template_directory_uri() . '/assets/images/left-sidebar.png',
			) ,
			'required' => array( 'custom_layout', '=', true ),
		) ,

 
		 
	),
);