<?php
namespace Vankineaddons;
if (! defined('ABSPATH' )){
	die('-1');
}
class Startvankine{
      /**
      * Instance
      *
      * @var $instance
      */
      private static $instance;
      /**
      * Initiator
      *
      * @since 1.0.0
      * @return object
      */
      public static function instance() {
        if ( ! isset( self::$instance ) ) {
          self::$instance = new self();
        }

        return self::$instance;
      }


      /**
      * Instantiate the object.
      *
      * @since 1.0.0
      *
      * @return void
      */
      public function __construct() {
          add_action('wp_enqueue_scripts', array($this, 'vankine_enqueue_scripts'));  
          add_action('elementor/editor/before_enqueue_scripts', array($this, 'vankine_elementor_scripts'));
          add_action( 'elementor/elements/categories_registered', array($this, 'add_category' ) );

      }

      

 	      /**
	      * Add  category
	      *
	      * @since 1.0.0
	      *
	      * @return void
	      */
	      public function add_category( $elements_manager ) {
            $elements_manager->add_category(
              '100',
              [
                  'title'  => 'Vankine Headers Content',
                  'icon' => 'font',
              ],
              1
            );
            $elements_manager->add_category(
              '101',
              [
                'title'  => 'Vankine Content',
                'icon' => 'font',
              ],
              2
            );
            $elements_manager->add_category(
              '102',
              [
                  'title'  => 'Vankine Posts',
                  'icon' => 'font',
              ],
              3
            );
         // $elements_manager->add_category(
           // '103',
              //[
               // 'title'  => 'Vankine Shop Content',
               // 'icon' => 'font',
            //  ],
           // 4
         // );
          $elements_manager->add_category(
              '104',
              [
                'title'  => 'Vankine Footer Content',
                'icon' => 'font',
              ],
            5
          );
	    }
      /**
      * Get All ths scriptis and styles
      *
      * @return void
      */
      public function vankine_enqueue_scripts(){
        global $vankine_theme_mod;
        $rtl_enable = isset( $vankine_theme_mod['rtl_enable'] ) ? $vankine_theme_mod['rtl_enable'] : '';
        if(is_rtl() || $rtl_enable == true){
          wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.rtl.min.css', array() , '5.0.2', 'all');
        }else{
          wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/plugins/bootstrap.min.css', array() , '5.0.2', 'all');
        }
        wp_enqueue_style('animate', VANKINE_ADDONS_URL . 'assets/css/animate.min.css', array() , '4.1.1', 'all'); 
        wp_enqueue_style('slick-style', VANKINE_ADDONS_URL . 'assets/css/slick.css', array() , '1.0', 'all');
        wp_enqueue_style('select2-style', VANKINE_ADDONS_URL . 'assets/css/select.min.css', array() , '3.7.2', 'all'); 
        wp_enqueue_style('owl-style', VANKINE_ADDONS_URL . 'assets/css/owl.css', array() , '2.3.4', 'all'); 
        wp_enqueue_style('vankine-forms', VANKINE_ADDONS_URL . 'assets/css/wp-forms-layour.css', array() , '2.3.4', 'all'); 
        wp_enqueue_style('fancybox-style', VANKINE_ADDONS_URL . 'assets/css/jquery.fancybox.min.css', array() , '3.5.7', 'all');
        wp_enqueue_style('rangestyle', VANKINE_ADDONS_URL . 'assets/css/rangeslider.css', array() , '1.0', 'all');
        wp_enqueue_style('vankine-meta-box', get_template_directory_uri() . '/assets/css/metabox.css' );    
        wp_enqueue_style('vankine-style', get_template_directory_uri().'/style.css' , array() , time() , 'all');  
        wp_enqueue_style('vankine-main-style', get_template_directory_uri() . '/assets/css/theme.css' , array() , time(), 'all'); 
        if(is_rtl() || $rtl_enable == true){
          wp_enqueue_style('vankine-main-rtl', get_template_directory_uri() . '/assets/css/rtl.css', array() , '1.0.0', 'all');
        }
        if(is_singular() && comments_open() && get_option('thread_comments')):
            wp_enqueue_script('comment-reply');
        endif;
        // ============================================================js start===================================================================================
        wp_enqueue_script('bootstrap-bundle', get_template_directory_uri() . '/assets/js/plugins/bootstrap.bundle.min.js', array('jquery') , '5.0.0', true);
        wp_enqueue_script('appear', VANKINE_ADDONS_URL . 'assets/js/plugins/appear.js', array('jquery') , '1.0', true);
        wp_enqueue_script('TweenMax', VANKINE_ADDONS_URL . 'assets/js/plugins/TweenMax.min.js', array('jquery') , '1.18.0', true);
        wp_enqueue_script('waypoints',  VANKINE_ADDONS_URL . 'assets/js/plugins/waypoints.js', array('jquery') , '4.0.1', true);
        wp_enqueue_script('select2', VANKINE_ADDONS_URL . 'assets/js/plugins/select.min.js', array('jquery') , '4.0.7', true);
        wp_enqueue_script('fancybox', VANKINE_ADDONS_URL . 'assets/js/plugins/jquery.fancybox.js', array('jquery') , '3.5.7', true);
        wp_enqueue_script('isotope', VANKINE_ADDONS_URL . 'assets/js/plugins/isotope.min.js', array('jquery') , '3.0.6', true);
        wp_enqueue_script('owl', VANKINE_ADDONS_URL . 'assets/js/plugins/owl.js', array('jquery') , '1.8.1', true);
        wp_enqueue_script('share', VANKINE_ADDONS_URL . 'assets/js/plugins/sharer.js', array('jquery') , '1.0.0', true);
        wp_enqueue_script('rangejs', VANKINE_ADDONS_URL . 'assets/js/plugins/rangeslider.min.js', array('jquery') , '2.3.2', true);
        wp_enqueue_script('counterup', VANKINE_ADDONS_URL . 'assets/js/plugins/counterup.js', array('jquery') , '2.0.0', true); 
        wp_enqueue_script('slick', VANKINE_ADDONS_URL . 'assets/js/plugins/slick.js', array('jquery') , '1.0', true);
        wp_enqueue_script('vankine-main', VANKINE_ADDONS_URL . 'assets/js/main.js', array('jquery' , 'imagesloaded') , '1.0.0', true);
        if(is_rtl() || $rtl_enable == true){
          wp_enqueue_script('vankine-carousel-active', VANKINE_ADDONS_URL . 'assets/js/main-rtl.js', array('jquery') , '1.0.0', true);
        }else{
          wp_enqueue_script('vankine-carousel-active', VANKINE_ADDONS_URL . 'assets/js/main-ltr-active.js', array('jquery') , '1.0.0', true);
        }
    }
   
    /**
    * Get All ths Elementor Call back scripts
    *
    * @return void
    */
    public function vankine_elementor_scripts(){
        wp_enqueue_style('uicons', get_template_directory_uri() . '/assets/css/vendors/uicons-regular-straight.css', array() , '1.0.0', 'all');
        wp_enqueue_style('icomoon', get_template_directory_uri() . '/assets/fonts/icomoon/icomoon.css', array() , '1.0.0', 'all');
    }
   
}