<?php
/*
** ===================
** Vankine Portfolio
** Post type : Portfolio;
** version: 1.0;
** Authour : Steeltheme;
** ===================
*/
namespace Vankineaddons\Plugins;
if (! defined('ABSPATH' )){
	die('-1');
}
class Portfolio{
   
	public function __construct() {
		add_action('init', array($this, 'portfolio_custom_post_type'));  
		add_action('init', array($this, 'portfolio_custom_taxonomies')); 
 
	}
	public function portfolio_custom_post_type() {
		register_post_type( 'portfolio',
		array(
			'labels' => array(
				'name' => esc_html_x('Portfolios', 'Post Type General Name', 'vankine-addons') ,
				'singular_name' => esc_html_x('Portfolio', 'Post Type General Name', 'vankine-addons') , 
				'add_new' =>  esc_html__('Add New', 'vankine-addons'),
				'add_new_item' =>   esc_html__('Add New Portfolio', 'vankine-addons'),
				'edit' => esc_html__('Edit', 'vankine-addons'),
				'edit_item' =>   esc_html__('Edit Portfolio', 'vankine-addons'),
				'new_item' =>   esc_html__('New Portfolio', 'vankine-addons'),
				'view' =>  esc_html__('View', 'vankine-addons'),
				'view_item' =>    esc_html__('View Portfolio', 'vankine-addons'),
				'search_items' =>   esc_html__('Search Portfolio', 'vankine-addons'),
				'not_found' =>   esc_html__('No Portfolio found', 'vankine-addons'),
				'not_found_in_trash' =>  esc_html__('No Portfolio found in Trash', 'vankine-addons'),
				'parent' =>  esc_html__('Parent Portfolio', 'vankine-addons')
			),
			'public' => true,
			'show_in_rest' => true,
			'menu_position' => 15,
			'supports' => array( 'title', 'excerpt' , 'thumbnail' , 'editor' , 'page-attributes' ),
			'taxonomies' => array( '' ),
			'show_in_nav_menus'   => true,
			'menu_position'       => 5,
			'menu_icon'           => 'dashicons-tagcloud',
			'has_archive' => false,
			'capability_type'    => 'post',
			'hierarchical'          => true,
		)
	);
}
public function portfolio_custom_taxonomies() {
		//add new taxonomy hierarchical
		$labels = array(
			'name' =>   esc_html__('Portfolio Categories', 'vankine-addons'),
			'singular_name' =>  esc_html__('Category', 'vankine-addons'),
			'search_items' =>  esc_html__('Search Category', 'vankine-addons'),
			'all_items' =>  esc_html__('All Category', 'vankine-addons'),
			'parent_item' =>  esc_html__('Parent Category', 'vankine-addons'),
			'parent_item_colon' =>   esc_html__('Parent Category:', 'vankine-addons'),
			'edit_item' =>   esc_html__('Edit Category', 'vankine-addons'),
			'update_item' =>   esc_html__('Update Category', 'vankine-addons'),
			'add_new_item' =>  esc_html__('Add New Portfolio Category', 'vankine-addons'),
			'new_item_name' =>   esc_html__('New Category Name', 'vankine-addons'),
			'menu_name' => esc_html__('Categories', 'vankine-addons')
		);
		$args = array(
			'hierarchical' => true,
			'labels' => $labels,
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'public'             => true,
			'publicly_queryable' => true,
			'show_in_rest' => true,
			'rewrite' => array( 'slug' => 'portfolio_category' )
		);
		register_taxonomy('portfolio_category', array('portfolio'), $args);
		//add new taxonomy NOT hierarchical
	}
}

?>